*****************************************************************************
**                      Replication do-file for article                    **
** Continuity Trumps? The impact of interviewer change on item nonresponse **
**                  authors: Kristin Hajek & Nina Schumann                 ** 
*****************************************************************************

****************************************************
** 1) Interviewer change and interviewer data set **
****************************************************

** Merging all anchor waves of pairfam data

clear
set more off
use "$w1data_v7\anchor1.dta", clear
keep intid id wave intd intm inty demodiff
rename intid intid_w1
rename wave wave_w1
rename demodiff demodiff_w1
foreach x in intd intm inty {
	ren `x' `x'_w1
}

merge 1:1 id using "$w2data_v6\anchor2.dta", keepusing(intid wave intd intm inty demodiff)
drop if _merge==2
rename intid intid_w2
rename wave wave_w2	
rename demodiff demodiff_w2
foreach x in intd intm inty {
	ren `x' `x'_w2
}
drop _merge
	
merge 1:1 id using "$w3data_v5\anchor3.dta", keepusing(intid wave intd intm inty demodiff)
drop if _merge==2
rename intid intid_w3
rename wave wave_w3	
rename demodiff demodiff_w3
foreach x in intd intm inty {
	ren `x' `x'_w3
}
drop _merge

merge 1:1 id using "$w4data_v4\anchor4.dta", keepusing(intid wave intd intm inty demodiff)
drop if _merge==2		
rename intid intid_w4
rename wave wave_w4	
rename demodiff demodiff_w4
foreach x in intd intm inty {
	ren `x' `x'_w4
}
drop _merge


merge 1:1 id using "$w5data_v3\anchor5.dta", keepusing(intid wave intd intm inty demodiff)
drop if _merge==2		
rename intid intid_w5
rename wave wave_w5	
rename demodiff demodiff_w5
foreach x in intd intm inty {
	ren `x' `x'_w5
}
drop _merge


merge 1:1 id using "$w6data_v2\anchor6.dta", keepusing(intid wave intd intm inty demodiff)
drop if _merge==2		
rename intid intid_w6
rename wave wave_w6
rename demodiff demodiff_w6
foreach x in intd intm inty {
	ren `x' `x'_w6
}
drop _merge


merge 1:1 id using "$w7data\anchor7.dta", keepusing(intid wave intd intm inty demodiff)
drop if _merge==2		
rename intid intid_w7
rename wave wave_w7
rename demodiff demodiff_w7
foreach x in intd intm inty {
	ren `x' `x'_w7
}
drop _merge

*****************************************************************************

** Generate interviewer change

* generate variable interviewer change
gen intchangeW1=0 
gen intchangeW2=0 if intid_w1==intid_w2 & intid_w1!=. & !inlist(intid_w2,.,-10) 		
replace intchangeW2=1 if intid_w1!=intid_w2 & intid_w1!=. & !inlist(intid_w2,.,-10) 
replace intchangeW2=. if intid_w2==-10 
tab intchangeW2, m 		// 1218 changes in wave 2

gen intchangeW3=0 if intid_w2==intid_w3 & !inlist(intid_w2,.,-10) & intid_w3!=.   // participated in wave 2 and 3, same interviewer
replace intchangeW3=1 if intid_w2!=intid_w3 & !inlist(intid_w2,.,-10) & intid_w3!=. // participated in wave 2 and 3, not same interviewer
replace intchangeW3=0 if intid_w1==intid_w3 &  inlist(intid_w2,.,-10) & intid_w1!=. & intid_w3!=.  // did not participate in wave 2
replace intchangeW3=1 if intid_w1!=intid_w3 &  inlist(intid_w2,.,-10) & intid_w1!=. & intid_w3!=.  // did not participate in wave 2
tab intchangeW3, m		//  878 changes in wave 3  

gen intchangeW4=0 if intid_w3==intid_w4 & intid_w3!=. & intid_w4!=. 
replace intchangeW4=1 if intid_w3!=intid_w4 & intid_w3!=. & intid_w4!=. 
replace intchangeW4=0 if intid_w2==intid_w4 & !inlist(intid_w2,.,-10) & intid_w3==. & intid_w4!=. 
replace intchangeW4=1 if intid_w2!=intid_w4 & !inlist(intid_w2,.,-10) & intid_w3==. & intid_w4!=.
replace intchangeW4=0 if intid_w1==intid_w4 &  inlist(intid_w2,.,-10) & intid_w3==. & intid_w4!=.  // demodiff non participants wave 3
replace intchangeW4=1 if intid_w1!=intid_w4 &  inlist(intid_w2,.,-10) & intid_w3==. & intid_w4!=.  // demodiff non participants wave 3
tab intchangeW4, m		//  559 changes in wave 4

gen intchangeW5=0 if intid_w4==intid_w5 & intid_w4!=. & intid_w5!=. 
replace intchangeW5=1 if intid_w4!=intid_w5 & intid_w4!=. & intid_w5!=. 
replace intchangeW5=0 if intid_w3==intid_w5 & intid_w3!=. & intid_w4==. & intid_w5!=. 
replace intchangeW5=1 if intid_w3!=intid_w5 & intid_w3!=. & intid_w4==. & intid_w5!=.
tab intchangeW5, m		//  666 changes in wave 5 

gen intchangeW6=0 if intid_w5==intid_w6 & intid_w5!=. & intid_w6!=. 
replace intchangeW6=1 if intid_w5!=intid_w6 & intid_w5!=. & intid_w6!=. 
replace intchangeW6=0 if intid_w4==intid_w6 & intid_w4!=. & intid_w5==. & intid_w6!=. 
replace intchangeW6=1 if intid_w4!=intid_w6 & intid_w4!=. & intid_w5==. & intid_w6!=.
tab intchangeW6, m		//  535 changes in wave 6

gen intchangeW7=0 if intid_w6==intid_w7 & intid_w6!=. & intid_w7!=. 
replace intchangeW7=1 if intid_w6!=intid_w7 & intid_w6!=. & intid_w7!=. 
replace intchangeW7=0 if intid_w5==intid_w7 & intid_w5!=. & intid_w6==. & intid_w7!=. 
replace intchangeW7=1 if intid_w5!=intid_w7 & intid_w5!=. & intid_w6==. & intid_w7!=.
tab intchangeW7, m		//  585 changes in wave 7

count	// 12.402

preserve
keep  intchangeW* id
save "$Intwechsel\1_int.dta", replace
restore 
drop intchangeW*

*****************************************************************************

** Generate interviewer data set

reshape long wave_w@ intid_w@, i(id) j(welle)
drop if intid_w==.		// not participated in wave, so no interviewer ID
gen demodiff=.
forvalues x=1/7 {
replace demodiff=demodiff_w`x' if `x'==welle 	
}
tab demodiff, m	// no Demodiff cases
count	// 53,447

ren intid_w intid
sort intid welle
order intid id welle

gen intd=0
gen intm=0
gen inty=0
forvalues x=1/7 {
	replace intd=intd_w`x' if `x'==welle
	replace intm=intm_w`x' if `x'==welle
	replace inty=inty_w`x' if `x'==welle
}
drop intd_w* intm_w* inty_w* wave_w demodiff_w*

sort intid welle inty intm intd 

preserve
by intid: gen intnum=_n		// interview experience. Be careful: sometimes several interviews in one day
keep id intid intnum welle
ren welle wave
sort id wave
save  "$Intwechsel\0_interviewer_1.dta", replace
restore

* interviewer experience
by intid: gen intnum=_n		// be careful: sometimes several interviews in one day
forvalues x=1/7 {
	gen intnum_w`x'=intnum if welle==`x'
}

* interviewer experience per wave
forvalues x=1/7 {
	by intid: egen exp_w`x'=count(welle) if welle==`x'
}
forvalues x=1/7 {
	by intid: replace exp_w`x'=exp_w`x'[_n-1] if exp_w`x'==.
	by intid: replace exp_w`x'=exp_w`x'[_N] if exp_w`x'==.
}
for num 1/7: recode exp_wX .=0

* only one line per interviewer
drop if intid==intid[_n+1]
count

* only keep intid and experience of interviewer
keep intid exp* /*entryyear*/

gen exityear2=.  // last exit year, for example intid=1041
forvalues x=2/7 {
	local y=`x'-1
	replace exityear2=`x' if exp_w`x'==0 & exp_w`y'!=0
}

gen exityear1=.  // earlier exit year
forvalues x=2/7 {
	local y=`x'-1
	replace exityear1=`x' if exp_w`x'==0 & exp_w`y'!=0 & exityear2>`x'
}

gen exityear=.  // more exits? => one case
forvalues x=2/7 {
	local y=`x'-1
	replace exityear=`x' if exp_w`x'==0 & exp_w`y'!=0 & exityear1>`x' & exityear2>`x'
}

tab1 exityear*, m
l intid exityear2 exityear1 exityear if exityear==2	// intid 1041
replace exityear=exityear1 if exityear1!=.
replace exityear=exityear2 if exityear2!=.
*br intid exityear* exp*
drop exityear1 exityear2

save "$Intwechsel\0_interviewer_2.dta", replace


